-- Enable CDC for Database
exec sys.sp_cdc_enable_db
exec sys.sp_cdc_disable_db

-- Enable CDC for Customer Table
EXEC sys.sp_cdc_enable_table  
@source_schema = N'dbo',  
@source_name   = N'dimCustomer',  
@role_name     = null, --N'MyRole',  
@filegroup_name = N'Primary',  
@supports_net_changes = 1  
GO  

-- truncate and load dimCustomer
delete from dbo.dimCustomer where customerID <= 100

insert into
	dbo.dimCustomer
select
	cu.CustomerID
	, cu.CustomerName
	, bg.BuyingGroupName
	, ci.CityName
	, sp.StateProvinceCode
	, sp.StateProvinceName
	, co.CountryName
	, cu.CreditLimit
	, getdate() as effectiveDate
	, null as obsoleteDate
	, N'WideWorld' as sourceID
	, N'123' as ETLBatchID
	, getdate() as createDate
	, N'sreagin' as createdBy
	, getdate() as modifiedDate
	, N'sreagin' as modifiedBy
from
	WideWorldImporters.sales.Customers cu
	left outer join WideWorldImporters.sales.BuyingGroups bg on bg.BuyingGroupID = cu.BuyingGroupID
	left outer join WideWorldImporters.[Application].cities ci on ci.CityID = cu.DeliveryCityID
	left outer join WideWorldImporters.[Application].StateProvinces sp on sp.StateProvinceID = ci.StateProvinceID
	left outer join WideWorldImporters.[Application].Countries co on co.CountryID = sp.CountryID
where
	cu.CustomerID <= 100
